﻿using System;
using System.Collections.Generic;
using System.Linq;
using Windows.Foundation;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

using Windows.UI.Xaml.Shapes;
using Windows.UI;

namespace CanvasShapes
{
    public sealed partial class MainPage : Page
    {
        int tap = 0;
        List<SolidColorBrush> Kolory = new List<SolidColorBrush>();
        List<Point> TapPoints = new List<Point>();

        public MainPage()
        {
            this.InitializeComponent();

            Kolory.Add(new SolidColorBrush(Colors.Black));
            Kolory.Add(new SolidColorBrush(Colors.Gray));
            Kolory.Add(new SolidColorBrush(Colors.LightGray));
            Kolory.Add(new SolidColorBrush(Colors.White));
            Kolory.Add(new SolidColorBrush(Colors.Brown));
            Kolory.Add(new SolidColorBrush(Colors.LightCoral)); 
            Kolory.Add(new SolidColorBrush(Colors.Red));
            Kolory.Add(new SolidColorBrush(Colors.Pink));
            Kolory.Add(new SolidColorBrush(Colors.Orange));
            Kolory.Add(new SolidColorBrush(Colors.Gold)); 
            Kolory.Add(new SolidColorBrush(Colors.Yellow));
            Kolory.Add(new SolidColorBrush(Colors.LightYellow));
            Kolory.Add(new SolidColorBrush(Colors.Green));
            Kolory.Add(new SolidColorBrush(Colors.Lime));
            Kolory.Add(new SolidColorBrush(Colors.Turquoise));
            Kolory.Add(new SolidColorBrush(Colors.AliceBlue));
            Kolory.Add(new SolidColorBrush(Colors.Indigo));
            Kolory.Add(new SolidColorBrush(Colors.DarkBlue));
            Kolory.Add(new SolidColorBrush(Colors.Purple));
            Kolory.Add(new SolidColorBrush(Colors.Lavender));
            Kolory.Add(new SolidColorBrush(Colors.Transparent));

            List<Rectangle> K = new List<Rectangle>();
            List<Rectangle> K1 = new List<Rectangle>();
            foreach (SolidColorBrush i in Kolory)
            {
                Rectangle rec = new Rectangle
                {
                    Width = 200,
                    Height = 100,
                    Fill = i
                };
                Rectangle rec1 = new Rectangle
                {
                    Width = 200,
                    Height = 100,
                    Fill = i
                };
                K.Add(rec);
                K1.Add(rec1);
            }
            

            KolorTlo.ItemsSource = K;
            KolorObrys.ItemsSource = K1;

            KolorTlo.SelectedIndex = 0;
            KolorObrys.SelectedIndex = 0;
                       
        }

        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
        }

        private void Kartka_Tapped_1(object sender, TappedRoutedEventArgs e)
        {
            Point TapPoint = e.GetPosition(Kartka);
            
            TapPoints.Add(TapPoint);
            tap++;

        }

        private void CzyscListeTapPoints()
        {
            TapPoints.Clear();
            tap = 0;
        }

        private void BtCofnij_Click_1(object sender, RoutedEventArgs e)
        {
            if (tap > 0)
                CzyscListeTapPoints();
            else if(Kartka.Children.Count() > 0)
                Kartka.Children.RemoveAt(Kartka.Children.Count()-1);
        }

        
        #region Obsługa_Rysowania

        private void RysLinia_Click_1(object sender, RoutedEventArgs e)
        {
            if (TapPoints.Count() >= 2)
                DrawLine(Kartka, TapPoints[TapPoints.Count()-1], TapPoints[TapPoints.Count()-2], Kolory[KolorObrys.SelectedIndex], Double.Parse(GruboscObrysu.Text));
            CzyscListeTapPoints();
        }

        private void RysProstokat_Click_1(object sender, RoutedEventArgs e)
        {
            if (TapPoints.Count() >= 2)
            {
                DrawRectangle(Kartka, new Thickness(
                        Math.Min(TapPoints[TapPoints.Count() - 2].X, TapPoints[TapPoints.Count() - 1].X),
                        Math.Min(TapPoints[TapPoints.Count() - 2].Y, TapPoints[TapPoints.Count() - 1].Y),0, 0),                   
                        TapPoints[TapPoints.Count() - 1].X - TapPoints[TapPoints.Count() - 2].X, TapPoints[TapPoints.Count() - 1].Y - TapPoints[TapPoints.Count() - 2].Y,
                        Kolory[KolorTlo.SelectedIndex], Kolory[KolorObrys.SelectedIndex], Double.Parse(GruboscObrysu.Text));
            }
            CzyscListeTapPoints();
        }

        private void RysKolo_Click_1(object sender, RoutedEventArgs e)
        {
            if (TapPoints.Count() >= 2)
            {
                DrawEllipse(Kartka, new Thickness(
                        Math.Min(TapPoints[TapPoints.Count() - 2].X, TapPoints[TapPoints.Count() - 1].X),
                        Math.Min(TapPoints[TapPoints.Count() - 2].Y, TapPoints[TapPoints.Count() - 1].Y), 0, 0),
                        TapPoints[TapPoints.Count() - 1].X - TapPoints[TapPoints.Count() - 2].X, TapPoints[TapPoints.Count() - 1].Y - TapPoints[TapPoints.Count() - 2].Y,
                        Kolory[KolorTlo.SelectedIndex], Kolory[KolorObrys.SelectedIndex], Double.Parse(GruboscObrysu.Text));
            }
            CzyscListeTapPoints();
        }

        private void RysPolilinia_Click_1(object sender, RoutedEventArgs e)
        {
            if (TapPoints.Count() >= 2)
            {
                DrawPolyline(Kartka, Kolory[KolorTlo.SelectedIndex], Double.Parse(GruboscObrysu.Text), tap, TapPoints);
            }
            CzyscListeTapPoints();
        }

        private void RysPoligon_Click_1(object sender, RoutedEventArgs e)
        {
            if (TapPoints.Count() >= 2)
            {
                DrawPolygon(Kartka, Kolory[KolorTlo.SelectedIndex], Kolory[KolorObrys.SelectedIndex], Double.Parse(GruboscObrysu.Text), tap, TapPoints);
            }
            CzyscListeTapPoints();
        }

        private void RysText_Click_1(object sender, RoutedEventArgs e)
        {
            if (tap >= 1)
            {
                DrawTextBlock(Kartka, 100, new Thickness(TapPoints[TapPoints.Count() - 1].X,TapPoints[TapPoints.Count() - 1].Y, 0, 0),
                            Kolory[KolorObrys.SelectedIndex], ZawartoscText.Text, Int16.Parse(GruboscObrysu.Text));
            }
            CzyscListeTapPoints();
        }

        #endregion Obsługa_Rysowania
        

        #region SHAPES

        void DrawLine(Canvas p, Point start, Point end, SolidColorBrush color, double thickness)
        {
            Line line = new Line();
            line.X1 = start.X;
            line.Y1 = start.Y;
            line.X2 = end.X;
            line.Y2 = end.Y;
            line.Stroke = color;
            line.StrokeThickness = thickness;

            p.Children.Add(line);
        }

        void DrawRectangle(Canvas p, Thickness position, double width, double height, SolidColorBrush fill, SolidColorBrush stroke, double thickness)
        {
            Rectangle rect = new Rectangle();
            rect.HorizontalAlignment = HorizontalAlignment.Left;
            rect.VerticalAlignment = VerticalAlignment.Top;
            rect.Margin = position;
            rect.Width = Math.Abs(width);
            rect.Height = Math.Abs(height);
            rect.Stroke = stroke;
            rect.Fill = fill;
            rect.StrokeThickness = thickness;

            p.Children.Add(rect);
        }

        void DrawTextBlock(Canvas p, double height, Thickness thickness,SolidColorBrush col, string text,int FSize)
        {
            TextBlock textB = new TextBlock();
            textB.Height = height;
            textB.HorizontalAlignment = HorizontalAlignment.Left;
            textB.Margin = thickness;
            textB.Text = text;
            textB.FontSize = FSize;
            textB.Foreground = col;
            p.Children.Add(textB);
        }

        void DrawEllipse(Canvas p, Thickness position, double width, double height, SolidColorBrush fill, SolidColorBrush stroke, double thickness)
        {
            Ellipse el = new Ellipse();
            el.Fill = fill;
            el.StrokeThickness = thickness;
            el.Stroke = stroke;
            el.Width = Math.Abs(width);
            el.Height = Math.Abs(height);
            el.Margin = position;
            
            p.Children.Add(el);
        }

        void DrawPolygon(Canvas p, SolidColorBrush fill, SolidColorBrush stroke, double thickness, int numberOfpoints, List<Point> pts)
        {
            Polygon polygon = new Polygon();
            polygon.Stroke = stroke;
            polygon.StrokeThickness = thickness;
            polygon.Fill = fill;
            for (int i = 0; i < numberOfpoints; i++)
            {
                polygon.Points.Add(pts[i]);
            }

            p.Children.Add(polygon);
        }

        void DrawPolyline(Canvas p, SolidColorBrush stroke, double thickness, int numberOfpoints, List<Point> pts)
        {
            Polyline polyline = new Polyline();
            polyline.Stroke = stroke;
            polyline.StrokeThickness = thickness;
            for (int i = 0; i < numberOfpoints; i++)
            {
                polyline.Points.Add(pts[i]);
            }

            p.Children.Add(polyline);
        }

        #endregion SHAPES

        
    }
}
